//$**************************************************************
//$					Copyright (C) 2010 by L-1 Identity Solutions
//$  Name:        $Workfile: TPAPI Sample AppDlg.h $
//$  Author:      $Author: Jmacdonald $
//$  Description:
//$
//
#pragma once
#include <afxmt.h>
#include "..\include\tpapi.h"
#include "CaptureDlg.h"

#define MAX_DEVLIST      4
#define INVALID_HANDLE  -1

class CTPAPISampleAppDlg : public CDialog
{
public:
   CTPAPISampleAppDlg(CWnd* pParent = NULL);
   ~CTPAPISampleAppDlg();

	enum { IDD = IDD_TPAPISAMPLEAPP_DIALOG };

   afx_msg void OnBnClickedRTQA();
   afx_msg void OnBnClickedReview();
   afx_msg void OnBnClickedAutoCap();
   afx_msg void OnBnClickedBtnPreview();
   afx_msg void OnBnClickedRadio500();
   afx_msg void OnBnClickedRadio1000();
   afx_msg void OnBnClickedBtnCalibrate();
   afx_msg void OnBnClickedBtnSaveas();
   afx_msg void OnCbnSelchangeComboFngr();
   afx_msg void OnBnClickedBtnRefresh();
   afx_msg void OnCbnSelchangeDevice();

protected:
   CMutex        *bmpMutex;
   HICON          m_hIcon;
   CComboBox     *m_fngr;
   CComboBox     *m_calib;
   CComboBox     *m_device;
   bool           bTPAPIInitialized;
   bool           m_deviceConnected;
   unsigned int   m_hDev;
   struct s_tpDevList m_devList[MAX_DEVLIST];
   int            XSize, YSize;
   unsigned char *pBitmapData;
   struct {
      int resolution;
      CBitmap bm;
   }              m_bmImage;
   CBitmap        bLogo, bApp;
   unsigned long  m_CaptureMode;
   unsigned int   m_RTQAThrhld;

   LRESULT OnUserInit(WPARAM,LPARAM);
   virtual BOOL OnInitDialog();
   afx_msg void OnPaint();
   afx_msg HCURSOR OnQueryDragIcon();
   afx_msg void OnTimer(UINT_PTR nIDEvent);
   afx_msg void OnClose();
   void EnableGUI(bool);
   void UpdateDeviceStatus(void);
private:
   CButton       *m_BtnStartCapture;
   CButton       *m_BtnCalibrate;
   CButton       *m_chkAutoCap;

   DECLARE_MESSAGE_MAP()
};
